<div class="container">
    <div class="bg-primary rounded p-5 mt-3 text-center">
        <h1 style="font-weight: bolder;" class="text-warning">AUTO BED</h1>
        <label for="" class="text-white" style="font-weight: bold;"><?= strtoupper($utama['NamaPerusahaan']); ?></label>
        <br>
        <small class="text-white"><small>BPJS KESEHATAN UPDATE SETIAP JAM 00:00</small></small>
    </div>
    <div hidden id="carouselExampleControls" class="carousel slide mt-3" data-bs-ride="carousel">
        <div class="carousel-inner">
            <div class="carousel-item active">
                <div class="card">
                    <div class="card-body">
                        <table class="table table-striped">
                            <tr style="text-align: center;">
                                <td>
                                    <h1 style="font-weight: bolder;">RUANGAN</h1>
                                </td>
                                <td>
                                    <h1 style="font-weight: bolder;">:</h1>
                                </td>
                                <td>
                                    <h1 style="font-weight: bolder;">KELAS 1</h1>
                                </td>
                            </tr>
                            <tr style="text-align: center;">
                                <td>
                                    <h1 style="font-weight: bolder;">ISI</h1>
                                </td>
                                <td>
                                    <h1 style="font-weight: bolder;">:</h1>
                                </td>
                                <td>
                                    <h1 style="font-weight: bolder;">10</h1>
                                </td>
                            </tr>
                            <tr style="text-align: center;">
                                <td>
                                    <h1 style="font-weight: bolder;">KOSONG</h1>
                                </td>
                                <td>
                                    <h1 style="font-weight: bolder;">:</h1>
                                </td>
                                <td>
                                    <h1 style="font-weight: bolder;">10</h1>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>
    </div>

    <div class="card mt-3 mb-3">
        <div class="card-body">
            <table class="table table-striped">
                <tr>
                <th>
                    <input type="checkbox" id="select-db-all"> Pilih
                </th>
                    <th>NO</th>
                    <th>KODE RUANGAN</th>
                    <th>RUANGAN</th>
                    <th>KODE KELAS</th>
                    <th>ISI</th>
                    <th>KOSONG</th>
                    <th>TOTAL</th>
                    <th>ACTION</th>
                </tr>
                <?php
                $no = 1;
                foreach ($getRoom as $room) :
                ?>
                    <tr>
                    <td>
                        <input type="checkbox" class="select-db"
                            data-koderuang="<?= $room['KD_RUANGAN']; ?>"
                            data-kodekelas="<?= $room['KODE_KELAS']; ?>">
                    </td>
                        <td><?= $no++; ?></td>
                        <td><?= $room['KD_RUANGAN']; ?></td>
                        <td><?= $room['NM_RUANGAN']; ?></td>
                        <td><?= $room['KODE_KELAS']; ?></td>
                        <td><?= $room['ISI']; ?></td>
                        <td><?= $room['KOSONG']; ?></td>
                        <td><?= $room['TOTAL']; ?></td>
                        <td>
                            <button class="btn btn-warning btn-sm btn-tambah"
                                data-kd_ruangan="<?= $room['KD_RUANGAN']; ?>"
                                data-ruangan="<?= $room['NM_RUANGAN']; ?>"
                                data-kode_kelas="<?= $room['KODE_KELAS']; ?>"
                                data-isi="<?= $room['ISI']; ?>"
                                data-kosong="<?= $room['KOSONG']; ?>"
                                data-total="<?= $room['TOTAL']; ?>">
                                <i class="fas fa-edit"></i> Tambah
                            </button>
                        </td>
                    </tr>
                <?php
                endforeach;
                ?>
            </table>
        </div>
    </div>

    <!DOCTYPE html>
    <html lang="en">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <button class="btn btn-primary" id="btn-getData">Get Data Aplicare</button>
    <button class="btn btn-success" id="btn-newData">New Room Aplicare</button>
    <button class="btn btn-warning" id="updatejkn"><i class="fa fa-sync"></i> Update All Aplicare</button>
    <button class="btn btn-warning" id="btn-updateData">Update Aplicare</button>
    <div class="card mt-3 mb-3">
        <div class="card-body">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <!-- <th>
                            <input type="checkbox" id="select-all"> All
                        </th> -->
                        <th>Kode Ruang</th>
                        <th>Nama Ruang</th>
                        <th>Nama Kelas</th>
                        <th>Kapasitas</th>
                        <th>Tersedia</th>
                        <th>Tersedia Pria</th>
                        <th>Tersedia Wanita</th>
                        <th>Tersedia Pria & Wanita</th>
                    </tr>
                </thead>
                <tbody id="data-aplicares">
                </tbody>
            </table>
        </div>
    </div>

    <div class="card mt-3 mb-3">
        <div class="card-body">
            <table class="table table-striped">
                <button class="btn btn-danger" id="btn-deleteData">Delete</button>
            </table>
        </div>
    </div>
</div>

<!-- Modal Insert -->
<div class="modal fade" id="modalNewRoom" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="formNewRoom">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Ruangan Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Kode Kelas</label>
                        <input type="text" name="kodekelas" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Kode Ruang</label>
                        <input type="text" name="koderuang" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Nama Ruang</label>
                        <input type="text" name="namaruang" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Kapasitas</label>
                        <input type="number" name="kapasitas" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Tersedia</label>
                        <input type="number" name="tersedia" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Tersedia Pria</label>
                        <input type="number" name="tersediapria" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Tersedia Wanita</label>
                        <input type="number" name="tersediawanita" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Tersedia Pria & Wanita</label>
                        <input type="number" name="tersediapriawanita" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEdit" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="formEdit">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Data Ruangan</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="kd_ruangan" id="edit_kd_ruangan">

                    <div class="form-group">
                        <label>Ruangan</label>
                        <input type="text" name="ruangan" id="edit_ruangan" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Isi</label>
                        <input type="number" name="isi" id="edit_isi" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Kosong</label>
                        <input type="number" name="kosong" id="edit_kosong" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Total</label>
                        <input type="number" name="total" id="edit_total" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    $(document).ready(function() {
        // ketika master checkbox di klik
        $(document).on("change", "#select-db-all", function() {
            $(".select-db").prop("checked", $(this).prop("checked"));
        });

        // kalau salah satu row dicentang/di-uncheck
        $(document).on("change", ".select-row", function() {
            if ($(".select-db:checked").length === $(".select-row").length) {
                $("#select-db-all").prop("checked", true);
            } else {
                $("#select-db-all").prop("checked", false);
            }
        });
    });


    // tutup modal
    $(document).on("click", ".btn-secondary", function() {
        $("#modalNewRoom").modal("hide");
    });
    $(document).on("click", ".close", function() {
        $("#modalNewRoom").modal("hide");
    });


    $(document).ready(function() {
        // load data
        $("#btn-getData").on("click", function() {
            $.ajax({
                url: "<?= base_url('aplicare/getData'); ?>",
                type: "POST",
                dataType: "json",
                beforeSend: function() {
                    $("#data-aplicares").html("<tr><td colspan='9'>Loading...</td></tr>");
                },
                success: function(res) {
                    let html = "";
                    if (res.status && res.data.length > 0) {
                        $.each(res.data, function(i, row) {
                            html += "<tr>" +
                                // "<td><input type='checkbox' class='select-row' data-koderuang='" + row.koderuang + "' data-kodekelas='" + row.kodekelas + "'></td>" +
                                "<td>" + row.koderuang + "</td>" +
                                "<td>" + row.namaruang + "</td>" +
                                "<td>" + row.namakelas + " (" + row.kodekelas + ")</td>" +
                                "<td>" + row.kapasitas + "</td>" +
                                "<td>" + row.tersedia + "</td>" +
                                "<td>" + row.tersediapria + "</td>" +
                                "<td>" + row.tersediawanita + "</td>" +
                                "<td>" + row.tersediapriawanita + "</td>" +
                                "</tr>";
                        });
                    } else {
                        html = "<tr><td colspan='9'>Data tidak tersedia</td></tr>";
                    }
                    $("#data-aplicares").html(html);
                }
            });
        });

        // select all checkbox
        $(document).on("change", "#select-all", function() {
            $(".select-row").prop("checked", $(this).prop("checked"));
        });

        // delete data
        $("#btn-deleteData").on("click", function() {
            let selected = [];
            $(".select-row:checked").each(function() {
                selected.push({
                    koderuang: $(this).data("koderuang"),
                    kodekelas: $(this).data("kodekelas")
                });
            });

            if (selected.length === 0) {
                alert("Pilih minimal satu data untuk dihapus!");
                return;
            }

            if (!confirm("Yakin hapus data terpilih?")) return;

            $.ajax({
                url: "<?= base_url('aplicare/deleteData'); ?>",
                type: "POST",
                dataType: "json",
                data: {
                    data: selected
                },
                success: function(res) {
                    if (res.status) {
                        alert("Data berhasil dihapus");
                        $("#btn-getData").click(); // reload data
                    } else {
                        alert("Gagal hapus: " + res.message);
                    }
                },
                error: function(xhr, status, error) {
                    alert("Error: " + error);
                }
            });
        });
    });

    // new room
    $(document).ready(function() {
        // buka modal
        $("#btn-newData").on("click", function() {
            $("#modalNewRoom").modal("show");
        });

        // submit form
        $("#formNewRoom").on("submit", function(e) {
            e.preventDefault();

            let formData = {
                kodekelas: $("input[name=kodekelas]").val(),
                koderuang: $("input[name=koderuang]").val(),
                namaruang: $("input[name=namaruang]").val(),
                kapasitas: $("input[name=kapasitas]").val(),
                tersedia: $("input[name=tersedia]").val(),
                tersediapria: $("input[name=tersediapria]").val(),
                tersediawanita: $("input[name=tersediawanita]").val(),
                tersediapriawanita: $("input[name=tersediapriawanita]").val()
            };

            $.ajax({
                url: "<?= base_url('aplicare/insertData'); ?>",
                type: "POST",
                dataType: "json",
                data: formData,
                success: function(res) {
                    if (res.status) {
                        alert("Data berhasil disimpan");
                        $("#modalNewRoom").modal("hide");
                        $("#btn-getData").click(); // reload data tabel
                    } else {
                        alert("Gagal simpan: " + res.message);
                    }
                },
                error: function(xhr, status, error) {
                    alert("Error: " + error);
                }
            });
        });
    });

    // update data mjkn
    $("#btn-updateData").on("click", function() {
    let selected = [];

    $(".select-db:checked").each(function() {
        let tr = $(this).closest("tr");

        selected.push({
            namaruang: tr.find("td:eq(3)").text(),
            koderuang: $(this).data("koderuang"),
            kodekelas: $(this).data("kodekelas"),
            kapasitas: tr.find("td:eq(7)").text(),
            tersedia: tr.find("td:eq(6)").text(),
            tersediapria: 0, 
            tersediawanita: 0, 
            tersediapriawanita: 0
        });
    });

    if (selected.length === 0) {
        alert("Pilih minimal 1 data dari database!");
        return;
    }

    if (!confirm("Yakin update data dari DATABASE ke JKN?")) return;

    $.ajax({
        url: "<?= base_url('aplicare/updateData'); ?>",
        type: "POST",
        dataType: "json",
        data: { data: selected },
        success: function(res) {
            alert(res.message);
        }
    });
});
</script>

<script>
    //Update All Aplicare Room
    $(document).ready(function() {
        $("#updatejkn").on("click", function() {
            if (!confirm("Yakin update semua data ke JKN?")) return;

            $.ajax({
                url: "<?= base_url('aplicare/updateAll'); ?>",
                type: "POST",
                dataType: "json",
                beforeSend: function() {
                    $("#updatejkn").prop("disabled", true).text("Updating...");
                },
                success: function(res) {
                    console.log(res);
                    if (res.status) {
                        alert("Semua data berhasil diupdate ke JKN");
                    } else {
                        alert(res.message);
                    }
                    $("#updatejkn").prop("disabled", false).html('<i class="fa fa-sync"></i> Update All Aplicare');
                },
                error: function(xhr, status, error) {
                    alert("Error: " + error);
                    $("#updatejkn").prop("disabled", false).html('<i class="fa fa-sync"></i> Update All Aplicare');
                }
            });
        });
    });

    //Tambah Ruangan
    $(document).on("click", ".btn-tambah", function() {
        let payload = {
            kodekelas: $(this).data("kode_kelas"),
            koderuang: $(this).data("kd_ruangan"),
            namaruang: $(this).data("ruangan"),
            kapasitas: $(this).data("total"),
            tersedia: $(this).data("kosong"),
            tersediapria: 0,
            tersediawanita: 0,
            tersediapriawanita: 0
        };

        if (!confirm("Yakin ingin menambah ruangan ini ke JKN?")) return;

        $.ajax({
            url: "<?= base_url('aplicare/tambahRoom'); ?>",
            type: "POST",
            dataType: "json",
            data: payload,
            success: function(res) {
                if (res.status) {
                    alert("✅ " + res.message);
                    $("#btn-getData").click(); // reload data tabel
                } else {
                    alert("❌ " + res.message);
                    // console.log(res.apiResponse);
                }
            },
            error: function(xhr, status, error) {
                alert("Error: " + error);
            }
        });
    });
</script>