<?php
defined('BASEPATH') or exit('No direct script access allowed');

class M_Bed extends CI_Model
{
    public function getRoom()
    {
        return $this->db->query("SELECT * FROM RoomBPJS");
    }

    public function getRoombed()
    {
        return $this->db->query("select * from XV_SYS_APLICARE");
    }

    public function getRoomAplicare()
    {
        $kelas = [
            'KELAS 1',
            'KELAS 2',
            'KELAS 3',
            'VVIP',
            'VIP',
            'HCU',
            'PICU',
            'NICU',
            'ICU',
            'ICCU'
        ];

        $this->db->where_in('KODE_KELAS', $kelas);
        return $this->db->get('Room_aplicare');
    }

    public function gethitungroom()
    {
        $sql = "
        SELECT 
            NAMA_KELAS AS Kelas,
            KODE_KELAS,
            SUM(ISI)    AS ISI,
            SUM(KOSONG) AS KOSONG,
            SUM(Total)  AS TOTAL
        FROM Room_aplicare
        WHERE NAMA_KELAS IN ('KELAS 1','KELAS 2','KELAS 3','VVIP','VIP')
        GROUP BY NAMA_KELAS, KODE_KELAS

        UNION ALL

        SELECT 
            NM_RUANGAN AS Kelas,
            KODE_KELAS,
            SUM(ISI)    AS ISI,
            SUM(KOSONG) AS KOSONG,
            SUM(Total)  AS TOTAL
        FROM Room_aplicare
        WHERE NM_RUANGAN IN ('HCU','ICU','ICCU')
        GROUP BY NM_RUANGAN, KODE_KELAS
    ";

        return $this->db->query($sql)->result_array();
    }

    public function insertData($payload)
    {
        $data = [
            "KD_RUANGAN" => $payload['koderuang'],
            "NM_RUANGAN" => $payload['namaruang'],
            "KODE_KELAS" => $payload['kodekelas'],
            "TOTAL"      => $payload['kapasitas'],
            "ISI"        => (int)$payload['kapasitas'] - (int)$payload['tersedia'],
            "KOSONG"     => $payload['tersedia'],
        ];

        return $this->db->insert('Room_aplicare', $data);
    }
}
