<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Taskid extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Task_Model');
    }

    public function send()
    {
        date_default_timezone_set("Asia/Jakarta");
        $tgl = date('Y-m-d');
        for ($i = 1; $i <= 7; $i++) {
            $tasks = $this->db->limit(5)
                ->order_by('datetime_created', 'ASC')
                ->get_where("erm_sendTaskId", ["taskid" => $i, "status_kirim" => 0, "date_created" => $tgl])
                ->result();

            if (!empty($tasks)) {
                if ($i == 5) {
                    $this->loopingTaskKhusus($tasks);
                    $this->prosesAntreanFarmasi();
                } else {
                    $this->loopingTaskBiasa($tasks);
                }
            }
        }
    }

    private function loopingTaskBiasa($tasks)
    {
        foreach ($tasks as $send) {
            $res = $this->Task_Model->taskBpjs($send->kodebooking, $send->taskid);
            if (isset($res['metadata'])) {
                $kode = $res['metadata']['code'];
                $message = $res['metadata']['message'];

                @$caseid = $this->Task_Model->cases($send->kodebooking)->row()->caseid;

                if (@$caseid) {
                    $this->Task_Model->update($kode, $message, $send->kodebooking, $caseid, $send->taskid);
                }
            }
        }
    }


    private function loopingTaskKhusus($tasks)
    {
        foreach ($tasks as $send) {
            $resSatu = $this->Task_Model->taskBpjs2($send->kodebooking, $send->taskid, $send->jenisresep);
            if (isset($resSatu['metadata'])) {
                $kode = $resSatu['metadata']['code'];
                $message = $resSatu['metadata']['message'];

                @$caseid = $this->Task_Model->cases($send->kodebooking)->row()->caseid;

                if ($caseid) {
                    $this->Task_Model->update($kode, $message, $send->kodebooking, $caseid, $send->taskid);
                }
            }
        }
    }

    private function prosesAntreanFarmasi()
    {
        $antrean = $this->db->limit(5)
            ->order_by('date_created', 'ASC')
            ->get_where("erm_sendTaskId", ["servis" => "add antrean farmasi", "status_kirim" => 0])
            ->result();

        if (!empty($antrean)) {
            foreach ($antrean as $send) {
                $res = $this->Task_Model->antrian($send->kodebooking, $send->nomorantrianresep, $send->jenisresep);
                if (isset($res['metadata'])) {
                    $kode = $res['metadata']['code'];
                    $message = $res['metadata']['message'];
                    $this->Task_Model->updateAntrian($kode, $message, $send->kodebooking);
                }
            }
        }
    }
}
