<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AutoBed extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper('url');
        $this->load->model('M_Utama');
        $this->load->model('M_Bed');
    }

    public function index()
    {
        $data['utama'] = $this->M_Utama->getPerusahaan()->row_array();
        $data['getRoom'] = $this->M_Bed->getRoombed()->result_array();
        $this->load->view('properti/header');
        $this->load->view('home/indexhome', $data);
        $this->load->view('properti/footer');
    }

    public function proses()
    {
        $rooms = $this->M_Bed->gethitungroom(); // sudah result_array()

        foreach ($rooms as $room) {
            $payload  = $this->buildPayload($room);

            // Debug payload
            echo "<pre>Payload:\n" . print_r($payload, true) . "</pre>";

            $response = $this->sendToAplicares($payload);

            // Debug response
            echo "<pre>Response:\n" . print_r($response, true) . "</pre>";
            echo "<hr>";
        }
    }

    /**
     * Bangun payload untuk BPJS Aplicares
     */
    private function buildPayload($room)
    {
        $kodekelas   = $room['KODE_KELAS'];
        $koderuang   = $room['Kelas'];
        $namaruang   = $room['Kelas'];
        $kapasitas   = (int) $room['TOTAL'];
        $isi         = (int) $room['ISI'];
        $kosong      = (int) $room['KOSONG'];
        $null        =  0;

        // Total tersedia → default pakai jumlah kosong
        $tersedia             = $kosong;
        $tersediapria         = $null;
        $tersediawanita       = $null;
        $tersediapriawanita   = $null;

        // Validasi konsistensi data
        if ($tersedia !== $kosong) {
            echo "<pre>WARNING: Data tidak konsisten untuk {$namaruang}</pre>";
        }

        return [
            'kodekelas'          => (string) $kodekelas,
            'koderuang'          => (string) $koderuang,
            'namaruang'          => (string) $namaruang,
            'kapasitas'          => (string) $kapasitas,
            'tersedia'           => (string) $tersedia,
            'tersediapria'       => (string) $tersediapria,
            'tersediawanita'     => (string) $tersediawanita,
            'tersediapriawanita' => (string) $tersediapriawanita
        ];
    }


    /**
     * Kirim data ke BPJS Aplicares
     */
    private function sendToAplicares($payload)
    {
        $utama = $this->M_Utama->getPerusahaan()->row_array();
        $url   = rtrim($utama['IP_WS'], '/') . "/aplicares/kamar/UpdateKetersediaanTempatTidur";

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL            => $url,
            CURLOPT_CUSTOMREQUEST  => "POST",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS     => json_encode($payload),
            CURLOPT_HTTPHEADER     => ["Content-Type: application/json"]
        ]);

        $result   = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            return [
                'status'  => 'error',
                'message' => $error
            ];
        }

        curl_close($ch);

        // Jika response kosong atau HTTP 204
        if ($httpcode == 204 || empty($result)) {
            return [
                'status'   => 'nochange',
                'httpcode' => $httpcode,
                'message'  => 'Data sudah sama, tidak ada update.'
            ];
        }

        // Coba decode JSON
        $decoded = json_decode($result, true);

        if (isset($decoded['metadata'])) {
            return [
                'status'   => 'success',
                'httpcode' => $httpcode,
                'code'     => $decoded['metadata']['code'] ?? null,
                'message'  => $decoded['metadata']['message'] ?? null
            ];
        }

        return [
            'status'   => 'invalid',
            'httpcode' => $httpcode,
            'raw'      => $result
        ];
    }
}
