<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Aplicare extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper('url');
        $this->load->model('M_Utama');
        $this->load->model('M_Bed');
    }

    public function getData()
    {
        // ganti ip sesuai server API Anda
        $utama = $this->M_Utama->getPerusahaan()->row_array();
        $url   =  "http://192.168.1.49/api/aplicares/kamar/KetersediaanKamarRs";

        $postData = [
            "start" => "1",
            "limit" => "100"
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json"
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200 && $response) {
            $result = json_decode($response, true);

            echo json_encode([
                "status" => true,
                "data"   => $result["response"]["list"] ?? []
            ]);
        } else {
            echo json_encode([
                "status"  => false,
                "message" => "Gagal ambil data dari API"
            ]);
        }
    }

    public function deleteData()
    {
        $list = $this->input->post('data'); // array dari checkbox
        if (!$list) {
            echo json_encode(["status" => false, "message" => "Tidak ada data dipilih"]);
            return;
        }

        $success = [];
        $failed  = [];

        foreach ($list as $item) {
            $payload = [
                "kodekelas" => $item['kodekelas'],
                "koderuang" => $item['koderuang']
            ];

            $url = "http://192.168.1.49/api/aplicares/kamar/HapusRuangan";

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Content-Type: application/json"
            ]);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            // --- Simpan log (pastikan semua berupa string) ---
            $logData = [
                'request'       => json_encode($payload, JSON_UNESCAPED_UNICODE),
                'response'      => is_string($response) ? $response : json_encode($response, JSON_UNESCAPED_UNICODE),
                'createdDate'   => date('Y-m-d H:i:s'),
                'module'        => 'APLICARES_UPDATE',
                'url'           => $url,
                'headerRequest' => json_encode(["Content-Type" => "application/json"]),
                'methodType'    => 'POST',
            ];
            $this->db->insert('BPJS_log', $logData);

            if ($httpCode == 200 && $response) {
                $result = json_decode($response, true);

                if (!empty($result["metadata"]["code"]) && $result["metadata"]["code"] == 1) {
                    $success[] = $payload;
                } else {
                    $failed[] = [
                        "payload" => $payload,
                        "response" => $result
                    ];
                }
            } else {
                $failed[] = [
                    "payload" => $payload,
                    "response" => $response
                ];
            }
        }

        echo json_encode([
            "status"  => count($failed) === 0,
            "success" => $success,
            "failed"  => $failed,
            "message" => count($failed) === 0
                ? "Semua data berhasil dihapus"
                : "Sebagian data gagal dihapus"
        ]);
    }

    public function insertData()
    {
        $payload = [
            "kodekelas" => $this->input->post("kodekelas"),
            "koderuang" => $this->input->post("koderuang"),
            "namaruang" => $this->input->post("namaruang"),
            "kapasitas" => $this->input->post("kapasitas"),
            "tersedia" => $this->input->post("tersedia"),
            "tersediapria" => $this->input->post("tersediapria"),
            "tersediawanita" => $this->input->post("tersediawanita"),
            "tersediapriawanita" => $this->input->post("tersediapriawanita"),
        ];

        $this->M_Bed->insertData($payload);

        $url = "http://192.168.1.49/api/aplicares/kamar/RuanganBaru";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json"
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

      // --- Simpan log (pastikan semua berupa string) ---
      $logData = [
        'request'       => json_encode($payload, JSON_UNESCAPED_UNICODE),
        'response'      => is_string($response) ? $response : json_encode($response, JSON_UNESCAPED_UNICODE),
        'createdDate'   => date('Y-m-d H:i:s'),
        'module'        => 'APLICARES_UPDATE',
        'url'           => $url,
        'headerRequest' => json_encode(["Content-Type" => "application/json"]),
        'methodType'    => 'POST',
    ];
    $this->db->insert('BPJS_log', $logData);

        if ($httpCode == 200 && $response) {
            $result = json_decode($response, true);

            echo json_encode([
                "status" => !empty($result["metadata"]["code"]) && $result["metadata"]["code"] == 1,
                "message" => $result["metadata"]["message"] ?? "Unknown response",
                "apiResponse" => $result
            ]);
        } else {
            echo json_encode([
                "status" => false,
                "message" => "Gagal menghubungi API"
            ]);
        }
    }

    public function updateData()
    {
        $list = $this->input->post('data'); // array dari AJAX
        if (!$list) {
            echo json_encode(["status" => false, "message" => "Tidak ada data dipilih"]);
            return;
        }

        $success = [];
        $failed  = [];

        foreach ($list as $item) {
            $payload = [
                "namaruang"           => $item['namaruang'],
                "koderuang"           => $item['koderuang'],
                "kodekelas"           => $item['kodekelas'],
                "kapasitas"           => (int)$item['kapasitas'],
                "tersedia"            => (int)$item['tersedia'],
                "tersediapria"        => (int)$item['tersediapria'],
                "tersediawanita"      => (int)$item['tersediawanita'],
                "tersediapriawanita"  => (int)$item['tersediapriawanita'],
            ];

            $url = "http://192.168.1.49/api/aplicares/kamar/UpdateKetersediaanTempatTidur";

            $maxRetry = 3;
            $attempt = 0;
            $successFlag = false;
            $lastResponse = null;
            $lastHttpCode = null;
            $lastError = null;

            while ($attempt < $maxRetry && !$successFlag) {
                $attempt++;

                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    "Content-Type: application/json"
                ]);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20); // max tunggu koneksi
                curl_setopt($ch, CURLOPT_TIMEOUT, 60);        // max tunggu total

                $response = curl_exec($ch);
                $error    = curl_error($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);

                $lastResponse = $response;
                $lastHttpCode = $httpCode;
                $lastError    = $error;

            // --- Simpan log (pastikan semua berupa string) ---
            $logData = [
                'request'       => json_encode($payload, JSON_UNESCAPED_UNICODE),
                'response'      => is_string($response) ? $response : json_encode($response, JSON_UNESCAPED_UNICODE),
                'createdDate'   => date('Y-m-d H:i:s'),
                'module'        => 'APLICARES_UPDATE',
                'url'           => $url,
                'headerRequest' => json_encode(["Content-Type" => "application/json"]),
                'methodType'    => 'POST',
            ];
            $this->db->insert('BPJS_log', $logData);

                if ($httpCode == 200 && $response) {
                    $result = json_decode($response, true);
                    if (!empty($result["metadata"]["code"]) && $result["metadata"]["code"] == 1) {
                        $successFlag = true;
                        $success[] = [
                            "payload"  => $payload,
                            "response" => $result
                        ];
                    } else {
                        $failed[] = [
                            "payload"  => $payload,
                            "response" => $result
                        ];
                        break; // tidak perlu retry kalau balasan API sudah jelas gagal
                    }
                } else {
                    // tunggu sebelum retry
                    sleep(2);
                }
            }

            if (!$successFlag) {
                $failed[] = [
                    "payload"  => $payload,
                    "response" => $lastResponse ?: $lastError,
                    "httpCode" => $lastHttpCode
                ];
            }

            // delay kecil antar request
            sleep(1);
        }

        echo json_encode([
            "status"  => count($failed) === 0,
            "success" => $success,
            "failed"  => $failed,
            "message" => count($failed) === 0
                ? "Semua data berhasil diupdate"
                : "Sebagian data gagal diupdate, cek detail response"
        ]);
    }

    public function getRoomById()
    {
        $id = $this->input->post('id');
        $room = $this->db->get_where('XV_SYS_APLICARE', ['KD_RUANGAN' => $id])->row_array();

        if ($room) {
            echo json_encode(["status" => true, "data" => $room]);
        } else {
            echo json_encode(["status" => false, "message" => "Data tidak ditemukan"]);
        }
    }

    public function updateAll()
    {
        $rooms = $this->db->get('Room_aplicare')->result_array();
    
        if (!$rooms) {
            echo json_encode([
                "status"  => false,
                "message" => "Tidak ada data di Room_aplicare"
            ]);
            return;
        }
    
        $url = "http://192.168.1.49/api/aplicares/kamar/UpdateKetersediaanTempatTidur";
        $success = [];
        $failed  = [];
    
        foreach ($rooms as $room) {
            // --- Mapping field sesuai kebutuhan API ---
            $payload = [
                "namaruang"          => trim($room['NM_RUANGAN']),
                "koderuang"          => trim($room['KD_RUANGAN']),
                "kodekelas"          => trim($room['KD_KELAS']),
                "kapasitas"          => (int) $room['TOTAL'],
                "tersedia"           => (int) $room['KOSONG'],
                "tersediapria"       => 0,
                "tersediawanita"     => 0,
                "tersediapriawanita" => 0,
            ];
    
            // --- Eksekusi CURL ---
            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST           => true,
                CURLOPT_POSTFIELDS     => json_encode($payload),
                CURLOPT_HTTPHEADER     => ["Content-Type: application/json"],
                CURLOPT_CONNECTTIMEOUT => 20,
                CURLOPT_TIMEOUT        => 60,
            ]);
    
            $response = curl_exec($ch);
            $error    = curl_error($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
    
            // --- Simpan log (pastikan semua berupa string) ---
            $logData = [
                'request'       => json_encode($payload, JSON_UNESCAPED_UNICODE),
                'response'      => is_string($response) ? $response : json_encode($response, JSON_UNESCAPED_UNICODE),
                'createdDate'   => date('Y-m-d H:i:s'),
                'module'        => 'APLICARES_UPDATE',
                'url'           => $url,
                'headerRequest' => json_encode(["Content-Type" => "application/json"]),
                'methodType'    => 'POST',
            ];
            $this->db->insert('BPJS_log', $logData);
    
            // --- Analisis hasil API ---
            if ($httpCode == 200 && !empty($response)) {
                $result = json_decode($response, true);
    
                if (!empty($result["metadata"]["code"]) && (int)$result["metadata"]["code"] === 1) {
                    // ✅ Berhasil update ke API → update flag_send di DB
                    $this->db->where('KD_RUANGAN', $room['KD_RUANGAN']);
                    $this->db->update('Room_aplicare', ['flag_send' => 1]);
    
                    $success[] = [
                        "room"     => $room['KD_RUANGAN'],
                        "payload"  => $payload,
                        "response" => $result,
                    ];
                } else {
                    $failed[] = [
                        "room"     => $room['KD_RUANGAN'],
                        "payload"  => $payload,
                        "response" => $result,
                    ];
                }
            } else {
                $failed[] = [
                    "room"     => $room['KD_RUANGAN'],
                    "payload"  => $payload,
                    "response" => $response ?: $error,
                    "httpCode" => $httpCode,
                ];
            }
    
            // --- Delay kecil agar tidak overload ke API ---
            usleep(500000); // 0.5 detik
        }
    
        // --- Output hasil ---
        echo json_encode([
            "status"  => count($failed) === 0,
            "success" => $success,
            "failed"  => $failed,
            "message" => count($failed) === 0
                ? "✅ Semua data berhasil diupdate"
                : "⚠️ Sebagian data gagal diupdate, cek detail response di log"
        ]);
    }
    

    public function tambahRoom()
    {
        $payload = [
            "kodekelas"          => $this->input->post("kodekelas"),
            "koderuang"          => $this->input->post("koderuang"),
            "namaruang"          => $this->input->post("namaruang"),
            "kapasitas"          => $this->input->post("kapasitas"),
            "tersedia"           => $this->input->post("tersedia"),
            "tersediapria"       => 0,
            "tersediawanita"     => 0,
            "tersediapriawanita" => 0
        ];

        $url = "http://192.168.1.49/api/aplicares/kamar/RuanganBaru";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json"
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // --- Simpan log (pastikan semua berupa string) ---
        $logData = [
            'request'       => json_encode($payload, JSON_UNESCAPED_UNICODE),
            'response'      => is_string($response) ? $response : json_encode($response, JSON_UNESCAPED_UNICODE),
            'createdDate'   => date('Y-m-d H:i:s'),
            'module'        => 'APLICARES_UPDATE',
            'url'           => $url,
            'headerRequest' => json_encode(["Content-Type" => "application/json"]),
            'methodType'    => 'POST',
        ];
        $this->db->insert('BPJS_log', $logData);

        if ($httpCode == 200 && $response) {
            $result = json_decode($response, true);

            echo json_encode([
                "status"      => !empty($result["metadata"]["code"]) && $result["metadata"]["code"] == 1,
                "message"     => $result["metadata"]["message"] ?? "Unknown response",
                "apiResponse" => $result
            ]);
        } else {
            echo json_encode([
                "status"  => false,
                "message" => "Gagal menghubungi API"
            ]);
        }
    }
}
